Attribute VB_Name = "Module1"
Option Explicit

Public Declare Function GetTickCount Lib "kernel32" () As Long
Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Public ud As Integer                'GPIB Port
Public GPIB_ADRS As Integer         'GPIB Address
Public IP_ADRS As String            'IP Address
Public TraceP(1000) As Integer      'Trace Data
Public bTrc() As Byte               'Trace Buffer


Public Function WaitMeasEnd() As Integer
    SendDtFunc ("*CLS")
    SendDtFunc ("OPR 16")
    WaitMeasEnd = Wait_Meas(10)
End Function

Public Function WaitAvgEnd() As Integer
    SendDtFunc ("*CLS")
    SendDtFunc ("OPR 256")
    WaitAvgEnd = Wait_Meas(10)
End Function

Public Function WaitSweepEnd() As Integer
    SendDtFunc ("*CLS")
    SendDtFunc ("OPR 8")
    WaitSweepEnd = Wait_Meas(10)
End Function

Public Function CH1_SweepEnd() As Integer
'-----*CLS; OPR 8;  Need in the main routine
    CH1_SweepEnd = Wait_Meas(10)
End Function

Public Function CH2_SweepEnd() As Integer
'-----*CLS; OPR 2048;  Need in the main routine
    CH2_SweepEnd = Wait_Meas(10)
End Function

Public Function CH1_Direct_SWP_End() As Integer
'--------------- Direct Sweep End Check -----------
'Return val
'0 = OK
'1 = Meas error
Dim ReadBuffer As String * 10
Dim OPRevt As Integer
Dim STtimer As Double
Dim Wtime As Long
'
STtimer = Timer
Wtime = 10                          'Time Out 10sec
CH1_Direct_SWP_End = 0

Do
    DoEvents
    Sleep 2
    
    SendDtFunc ("OPREVT?")
    ReadBuffer = RcvDtFunc
    OPRevt = Val(ReadBuffer)
    Debug.Print "SPA OPREVT: " & OPRevt
    If Timer > (STtimer + Wtime) Then
        CH1_Direct_SWP_End = 2
        Exit Function
    End If
Loop While ((OPRevt And 8) = 0)

End Function

Public Function CH2_Direct_SWP_End() As Integer
'--------------- Direct Sweep End Check -----------
'Return val
'0 = OK
'1 = Meas error
Dim ReadBuffer As String * 10
Dim OPRevt As Integer
Dim STtimer As Double
Dim Wtime As Long
'
STtimer = Timer
Wtime = 10                          'Time Out 10sec
CH2_Direct_SWP_End = 0

Do
    DoEvents
    Sleep 2
    
    SendDtFunc ("OPREVT?")
    ReadBuffer = RcvDtFunc
    OPRevt = Val(ReadBuffer)
    Debug.Print "SPA OPREVT: " & OPRevt
    If Timer > (STtimer + Wtime) Then
        CH2_Direct_SWP_End = 2
        Exit Function
    End If
Loop While ((OPRevt And 2048) = 0)

End Function

Private Function Wait_Meas(Wtime As Long) As Integer
'Return val
'0 = OK
'1 = Meas error
'2 = Timed out
'
Dim Stat As Integer
Dim ReadBuffer As String * 10
Dim STtimer As Double
    
SendDtFunc ("*SRE 160")

Wait_Meas = 0
STtimer = Timer

Do
    DoEvents
    Sleep 2
    
    SendDtFunc ("*STB?")
    ReadBuffer = RcvDtFunc
    Stat = Val(ReadBuffer)
    Debug.Print "SPA STAT: " & Stat
    'Debug.Print "SPA STAT: " & Stat, ibsta
    If Timer > (STtimer + Wtime) Then
        Wait_Meas = 2
        Exit Function
    End If
Loop While ((Stat And 128) = 0) And ((Stat And 32) = 0)
Debug.Print "SPA STAT: " & Stat

If (Stat And 32) Then
    SendDtFunc ("*ESR?")
    ReadBuffer = RcvDtFunc
    Stat = Val(ReadBuffer)
    If (Stat And 16 + 8) Then
        Wait_Meas = 1
    End If
End If

End Function

